/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.urbancode.commons.util.query.QueryFilter;
import com.urbancode.release.rest.framework.QueryParams;
import com.urbancode.release.rest.models.Event;
import com.urbancode.release.rest.models.internal.Milestone;
import com.urbancode.release.rest.models.internal.ScheduledDeployment;
import com.urbancode.release.rest.models.internal.TaskExecution;

public class UserDashboard {
    public ScheduledDeployment[] getScheduledDeploymentsForCurrentUser(long dateFrom, long dateTo, boolean applyUserFilters) {
        ScheduledDeployment client = new ScheduledDeployment();
        client.format("dashboardDeployment");
        return (ScheduledDeployment[])((ScheduledDeployment)client.overridenPath("scheduledDeployments/filteredByUserTeams")).param("applyUserFilters", applyUserFilters + "").filter("scheduledDate", QueryParams.FilterClass.LONG, QueryFilter.FilterType.RANGE, dateFrom, dateTo).when().getAll();
    }

    public ScheduledDeployment[] getScheduledDeploymentsForCurrentUser(long dateFrom, long dateTo) {
        return this.getScheduledDeploymentsForCurrentUser(dateFrom, dateTo, false);
    }

    public ScheduledDeployment[] getScheduledDeploymentsNotPassingGatesForCurrentUser(long dateFrom, long dateTo) {
        return (ScheduledDeployment[])((ScheduledDeployment)new ScheduledDeployment().overridenPath("scheduledDeployments/scheduledDeploymentsWithVersionNotPassingGates/" + dateFrom + "/" + dateTo)).getAll();
    }

    public TaskExecution[] getAllApprovalsForCurrentUser() {
        return (TaskExecution[])((TaskExecution)new TaskExecution().overridenPath("taskExecutions/openedApprovalsForUser")).getAll();
    }

    public TaskExecution[] getAllWaitingTasksForCurrentUser() {
        TaskExecution client = new TaskExecution();
        client.format("dashboardTask");
        return (TaskExecution[])((TaskExecution)client.overridenPath("taskExecutions/openTasksForUser")).getAll();
    }

    public TaskExecution[] getAllUpcomingTasksForCurrentUser(long dateFrom, long dateTo) {
        TaskExecution client = new TaskExecution();
        client.format("dashboardTask");
        return (TaskExecution[])((TaskExecution)client.overridenPath("taskExecutions/upcomingTasksForUser/" + dateFrom + "/" + dateTo)).getAll();
    }

    public TaskExecution[] getAllUnclaimedTasksForCurrentUser(long dateFrom, long dateTo) {
        TaskExecution client = new TaskExecution();
        client.format("dashboardTask");
        return (TaskExecution[])((TaskExecution)client.overridenPath("taskExecutions/unclaimedTasksForUser/" + dateFrom + "/" + dateTo)).getAll();
    }

    public Milestone[] getAllMilestonesForCurrentUser(long dateFrom, long dateTo) {
        Milestone client = new Milestone();
        client.format("dashboardMilestone");
        return (Milestone[])((Milestone)client.overridenPath("milestones/filteredByUser")).getAll();
    }

    public Event[] getAllEventsInRange(long dateFrom, long dateTo, boolean relatedDeployment) {
        Event client = new Event();
        if (relatedDeployment) {
            return (Event[])((Event)client.overridenPath(client.path() + "eventsInRange" + "/" + dateFrom + "/" + dateTo)).filter("relatedDeployment", QueryParams.FilterClass.UUID, QueryFilter.FilterType.NOT_NULL, new Object[]{QueryFilter.FilterType.NOT_NULL}).when().getAll();
        }
        return (Event[])((Event)client.overridenPath(client.path() + "eventsInRange" + "/" + dateFrom + "/" + dateTo)).filter("relatedDeployment", QueryParams.FilterClass.UUID, QueryFilter.FilterType.NULL, new Object[]{QueryFilter.FilterType.NULL}).when().getAll();
    }
}

