/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Release
 * (c) Copyright IBM Corporation 2015, 2017. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.tfs.MapBuilder
import com.urbancode.air.plugin.tfs.TFSFactory

import com.microsoft.tfs.core.clients.workitem.project.Project
import com.microsoft.tfs.core.clients.workitem.project.ProjectCollection
import com.microsoft.tfs.core.clients.workitem.WorkItemClient
import com.microsoft.tfs.core.TFSTeamProjectCollection

def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

String tfsCollectionName = props['tfsCollectionName']
String tfsPassword = props['tfsPassword']
String tfsUrl = props['tfsUrl']
String tfsUserName = props['tfsUserName']

def currentDirectory = new File(getClass().protectionDomain.codeSource.location.path).parent
System.setProperty("com.microsoft.tfs.jni.native.base-directory", currentDirectory + "/lib/native")

TFSTeamProjectCollection tfsCollection = null
Project[] projects = []
try {
    tfsCollection = TFSFactory.createTFSCollection(tfsCollectionName, tfsPassword, tfsUrl, tfsUserName)
    WorkItemClient wic = tfsCollection.getWorkItemClient()
    ProjectCollection pc = wic.getProjects()
    projects = pc.getProjects()
}
finally {
    if (tfsCollection) {
        tfsCollection.close()
    }
}

println "Projects available:"

if (projects != null) {
    if (projects.size() > 0) {
        projects.each {
            project-> println project.name
        }
    }
}
