#!/usr/bin/env groovy
/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Release
 * (c) Copyright IBM Corporation 2014, 2016. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
import java.net.URI
import java.net.URL
import java.nio.charset.Charset

import com.urbancode.air.AirPluginTool
import com.urbancode.release.rest.models.Change
import com.urbancode.release.rest.models.Initiative
import com.urbancode.release.rest.framework.Clients

def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

def integrationProviderId = props['releaseIntegrationProvider']
def releaseToken = props['releaseToken']
def serverUrl = props['releaseServerUrl']

//Authentication
Clients.loginWithToken(serverUrl, releaseToken)

new Change().deleteAllForIntegrationProvider(integrationProviderId)

def allChanges = new Change().getAllForIntegrationProvider(integrationProviderId)
if (allChanges.size() > 0) {
     throw new Exception("Changes could not be deleted!")
}
else {
    println("All changes have been deleted successfully")
}
