/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.tfs

import groovy.json.JsonSlurper

public class MappingBoxMapper {
    private HashMap map = new HashMap()

    MappingBoxMapper(String jsonStringMap, String releaseName, String integrationName) {
        JsonSlurper jsonSlurper = new groovy.json.JsonSlurper()

        def jsonListMap = jsonSlurper.parseText(jsonStringMap)
        def mapValue
        jsonListMap.each { atom ->
            mapValue = atom."${releaseName}"
            jsonSlurper.parseText(atom."${integrationName}").each { listItem ->
                map[listItem.toString()] = mapValue
            }
        }
    }

    public String getMapping(String integrationValue) {
        String result = map[integrationValue]

        if (!result) {
            result = 'NONE_VALUE'
        }

        return result
    }
}
