/*
* Licensed Materials - Property of HCL
* UrbanCode Deploy
* (c) Copyright HCL Technologies Ltd. 2019. All Rights Reserved.
*/
import com.urbancode.air.AirPluginTool

import java.net.URI
import java.net.URL
import java.nio.charset.Charset

import org.apache.log4j.Level
import org.apache.log4j.Logger

final def workDir = new File('.').canonicalFile

import com.urbancode.release.rest.models.Change
import com.urbancode.release.rest.models.Initiative
import com.urbancode.urelease.integration.xldeploy.http.XLRestClient
import com.urbancode.release.rest.framework.Clients

AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])
Properties props = apTool.getStepProperties()

String integrationProviderId = props['releaseIntegrationProvider']
String releaseToken = props['releaseToken']
String serverUrl = props['releaseServerUrl']
String xlUrl = props['xlUrl']
String xlUser = props['xlUser']
String xlPass = props['xlPass']

String logLevel = props['loggerLevel']
Logger.getRootLogger().setLevel(Level.toLevel(logLevel))
Logger logger = Logger.getLogger(getClass())

XLRestClient xlClient = new XLRestClient(xlUrl, xlUser, xlPass)
if (xlClient.checkConnection()) {
    logger.info("Successfully connected to XL Deploy server.")
}

//Authentication
Clients.loginWithToken(serverUrl, releaseToken)

logger.info("Successfully connected to UrbanCode Release server.")