/*
 * Licensed Materials - Property of HCL
 * UrbanCode Deploy
 * (c) Copyright HCL Technologies Ltd. 2019. All Rights Reserved.
 */
package com.urbancode.urelease.integration.xldeploy.config

public class XLTaskState {
    final List<String> passStates = ["EXECUTED", "DONE"]
    final List<String> failStates = ["FAILED", "ABORTED", "STOPPED", "CANCELLED"]

    public boolean passed
    public boolean failed
    public boolean running

    public XLTaskState(String state) {
        passOrFail(state.toUpperCase())
    }

    private passOrFail(state) {
        passed = passStates.contains(state)
        failed = failStates.contains(state)
        running = !passed && !failed
    }
}
