package com.urbancode.urelease.integration.xldeploy.sync

import com.urbancode.release.rest.framework.ClientIntegrated
import com.urbancode.release.rest.models.Inventory

class InventorySyncClient {
    List<Inventory> importList
    Inventory syncObject
    int syncMax
    int importCount
    int removalCount

    public InventorySyncClient(int syncMax) {
        this.importList = new ArrayList<Inventory>()
        this.syncObject = new Inventory()
        this.syncMax = syncMax
        this.importCount = 0
    }

    public void addImport(Inventory newImport) {
        importList.add(newImport)

        if (importList.size() >= syncMax) {
            syncImports()
        }
    }

    public void syncImports() {
        if (importList.size() > 0) {
            syncObject.sync(importList)
            importCount += importList.size()
            importList.clear()
        }
    }
}
