/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.util;

import com.google.common.collect.Lists;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.commons.util.query.QueryFilter;
import com.urbancode.commons.util.query.QueryResult;
import com.urbancode.commons.web.WebConfiguration;
import com.urbancode.commons.web.util.TableFilter;
import com.urbancode.persistence.hibernate.SessionLookup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriInfo;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateTableFilter<T>
extends TableFilter {
    private Class<?> clazz;

    public HibernateTableFilter(HttpServletRequest request, Class<?> clazz) {
        super(request);
        this.clazz = clazz;
    }

    public HibernateTableFilter(UriInfo uriInfo, HttpServletRequest request, Class<?> clazz) {
        super(uriInfo, request);
        String nameQueryParam = (String)uriInfo.getQueryParameters().getFirst((Object)"name");
        if (!StringUtil.isEmpty((String)nameQueryParam)) {
            this.addFilter("name", QueryFilter.FilterType.LIKE, nameQueryParam);
        }
        this.clazz = clazz;
    }

    public HibernateTableFilter(TableFilter filter, Class<?> clazz) {
        super(filter);
        this.clazz = clazz;
    }

    protected Class<?> getFilterClass() {
        return this.clazz;
    }

    public Criteria createCriteria() {
        SessionLookup sessionLookup = WebConfiguration.getInstance().getSessionLookup();
        if (sessionLookup == null) {
            throw new RuntimeException("WebConfiguration has not been set with a SessionLookup instance");
        }
        return sessionLookup.getSession().createCriteria(this.getFilterClass());
    }

    public QueryResult<T> getResult() {
        return this.getResult(this.createCriteria());
    }

    public String processFilterString(String filterString) {
        String result = filterString.replace("\\*", "*");
        if (!(result = result.replace('*', '%')).endsWith("%")) {
            result = result + "%";
        }
        if (!result.startsWith("%")) {
            result = "%" + result;
        }
        return result;
    }

    public QueryResult<T> getResultWithJoins(Criteria criteria, List<String> defaultAliases, List<AliasDef> extraJoins) {
        List<Object> ids;
        QueryResult result = new QueryResult((QueryFilter)this);
        ArrayList<String> aliases = new ArrayList<String>();
        if (defaultAliases != null) {
            aliases.addAll(defaultAliases);
        }
        Criteria idsCriteria = criteria;
        this.addFilters(aliases, idsCriteria);
        this.addOrder(aliases, idsCriteria);
        int start = this.getStartRecord();
        int size = this.getRowsPerPage();
        int endPlusOne = start + size;
        if (endPlusOne < size) {
            endPlusOne = Integer.MAX_VALUE;
        }
        if (this.getOrderField() == null) {
            idsCriteria.setProjection(Projections.distinct((Projection)Projections.id()));
            ids = idsCriteria.list();
            result.setTotalRecords((long)ids.size());
            ids = ids.subList(start, Math.min(ids.size(), endPlusOne));
        } else {
            idsCriteria.addOrder(Order.asc((String)"id"));
            idsCriteria.setProjection(Projections.distinct((Projection)Projections.projectionList().add((Projection)Projections.id()).add((Projection)Projections.property((String)this.getOrderField()))));
            List results = idsCriteria.list();
            ids = new ArrayList(Math.min(size, results.size()));
            Iterator it = results.iterator();
            Object previousId = null;
            int count = 0;
            int i = 0;
            while (it.hasNext()) {
                Object[] row = (Object[])it.next();
                Object currentId = row[0];
                if (i == 0) {
                    if (count >= start && count < endPlusOne) {
                        ids.add(currentId);
                    }
                    ++count;
                } else if (!previousId.equals(currentId)) {
                    if (count >= start && count < endPlusOne) {
                        ids.add(currentId);
                    }
                    ++count;
                }
                previousId = currentId;
                ++i;
            }
            result.setTotalRecords((long)count);
        }
        if (result.getTotalRecords() == 0L) {
            result.setResults(Collections.emptyList());
            return result;
        }
        if (ids.size() <= 1000) {
            result.setResults((Collection)this.executeMainQuery(extraJoins, aliases, ids));
        } else {
            List idPages = Lists.partition(ids, (int)1000);
            ArrayList resultAccum = new ArrayList(ids.size());
            for (List idPage : idPages) {
                resultAccum.addAll(this.executeMainQuery(extraJoins, aliases, idPage));
            }
            result.setResults(resultAccum);
        }
        return result;
    }

    protected List executeMainQuery(List<AliasDef> extraJoins, List<String> aliases, List<Object> ids) {
        Criteria mainCriteria = this.createCriteria();
        mainCriteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        for (AliasDef join : extraJoins) {
            this.makeAlias(aliases, join, mainCriteria);
        }
        aliases = new ArrayList<String>();
        this.addOrder(aliases, mainCriteria);
        mainCriteria.add(Restrictions.in((String)"id", ids));
        List list = mainCriteria.list();
        return list;
    }

    protected String makeAlias(List<String> aliases, String path, Criteria criteria, int joinType) {
        String[] segments = path.split("\\.");
        if (segments.length <= 1) {
            return path;
        }
        String cur = segments[0];
        if (!aliases.contains(cur)) {
            criteria.createAlias(cur, cur, joinType);
            aliases.add(cur);
        }
        for (int i = 1; i < segments.length - 1; ++i) {
            String shortPath = cur + '.' + segments[i];
            String alias = cur + segments[i];
            if (!aliases.contains(alias)) {
                criteria.createAlias(shortPath, alias, joinType);
                aliases.add(alias);
            }
            cur = alias;
        }
        return cur + '.' + segments[segments.length - 1];
    }

    protected void makeAlias(List<String> aliases, AliasDef aliasDef, Criteria criteria) {
        if (!aliases.contains(aliasDef.alias)) {
            criteria.createAlias(aliasDef.propertyPath, aliasDef.alias, 1);
            aliases.add(aliasDef.alias);
        }
    }

    protected void addFilters(List<String> aliases, Criteria criteria) {
        this.addFilters(aliases, criteria, 1);
    }

    protected void addFilters(List<String> aliases, Criteria criteria, int joinType) {
        for (QueryFilter.Filter filter : this.getFilters()) {
            String aliasedName = this.makeAlias(aliases, filter.getFieldName(), criteria, joinType);
            criteria.add(this.makeRestriction(filter, aliasedName));
        }
    }

    protected Criterion makeRestriction(QueryFilter.Filter filter, String aliasedName) {
        String filterName = filter.getFieldName();
        QueryFilter.FilterType filterType = filter.getFilterType();
        if (filterType == QueryFilter.FilterType.EQUALS) {
            return Restrictions.eq((String)aliasedName, (Object)this.getConvertedFilterValues(filterName).get(0));
        }
        if (filterType == QueryFilter.FilterType.NOT_EQUALS) {
            return Restrictions.ne((String)aliasedName, (Object)this.getConvertedFilterValues(filterName).get(0));
        }
        if (filterType == QueryFilter.FilterType.LIKE) {
            Object rawFilterString = filter.getValues().get(0);
            if (rawFilterString instanceof String) {
                String filterString = this.processFilterString((String)rawFilterString);
                return Restrictions.like((String)aliasedName, (Object)filterString).ignoreCase();
            }
            throw new IllegalArgumentException("A non-string value was given to a like filter.");
        }
        if (filterType == QueryFilter.FilterType.GREATER_THAN) {
            return Restrictions.gt((String)aliasedName, (Object)this.getConvertedFilterValues(filterName).get(0));
        }
        if (filterType == QueryFilter.FilterType.GREATER_OR_EQUAL) {
            return Restrictions.ge((String)aliasedName, (Object)this.getConvertedFilterValues(filterName).get(0));
        }
        if (filterType == QueryFilter.FilterType.LESS_THAN) {
            return Restrictions.lt((String)aliasedName, (Object)this.getConvertedFilterValues(filterName).get(0));
        }
        if (filterType == QueryFilter.FilterType.LESS_OR_EQUAL) {
            return Restrictions.le((String)aliasedName, (Object)this.getConvertedFilterValues(filterName).get(0));
        }
        if (filterType == QueryFilter.FilterType.IN) {
            return Restrictions.in((String)aliasedName, this.getConvertedFilterValues(filterName));
        }
        if (filterType == QueryFilter.FilterType.NULL) {
            return Restrictions.isNull((String)aliasedName);
        }
        if (filterType == QueryFilter.FilterType.NOT_NULL) {
            return Restrictions.isNotNull((String)aliasedName);
        }
        if (filterType == QueryFilter.FilterType.RANGE) {
            List<Object> values = this.getConvertedFilterValues(filterName);
            String filterClass = this.getFilterClass(filterName);
            if ("String".equals(filterClass)) {
                String hi;
                String lo = (String)values.get(0);
                if (lo.compareTo(hi = (String)values.get(1)) > 0) {
                    String temp = hi;
                    hi = lo;
                    lo = temp;
                }
                return Restrictions.between((String)aliasedName, (Object)lo, (Object)hi);
            }
            if ("Long".equals(filterClass)) {
                Long lo = (Long)values.get(0);
                Long hi = (Long)values.get(1);
                if (hi < lo) {
                    Long temp = hi;
                    hi = lo;
                    lo = temp;
                }
                return Restrictions.between((String)aliasedName, (Object)lo, (Object)hi);
            }
            if (filterClass == null) {
                Long lo = Long.valueOf((String)values.get(0));
                Long hi = Long.valueOf((String)values.get(1));
                if (hi < lo) {
                    Long temp = hi;
                    hi = lo;
                    lo = temp;
                }
                return Restrictions.between((String)aliasedName, (Object)lo, (Object)hi);
            }
            throw new IllegalArgumentException("Range filter not supported for data of class: " + filterClass);
        }
        throw new IllegalArgumentException("Unrecognized filter type");
    }

    protected void addOrder(List<String> aliases, Criteria criteria) {
        this.addOrder(aliases, criteria, 1, false);
    }

    protected void addOrder(List<String> aliases, Criteria criteria, int joinType, boolean ignoreCase) {
        if (this.getOrderField() != null) {
            String aliasedName = this.makeAlias(aliases, this.getOrderField(), criteria, joinType);
            Order order = null;
            order = this.isDescending() ? Order.desc((String)aliasedName) : Order.asc((String)aliasedName);
            if (ignoreCase) {
                order.ignoreCase();
            }
            criteria.addOrder(order);
        }
    }

    public QueryResult<T> getResult(Criteria criteria) {
        QueryResult result = new QueryResult((QueryFilter)this);
        int rowsPerPage = this.getRowsPerPage();
        ArrayList<String> aliases = new ArrayList<String>();
        this.addFilters(aliases, criteria, 0);
        criteria.setProjection(Projections.rowCount());
        long rowCount = (Long)criteria.uniqueResult();
        result.setTotalRecords(rowCount);
        this.addOrder(aliases, criteria, 0, true);
        criteria.setProjection(null);
        criteria.setResultTransformer(CriteriaSpecification.ROOT_ENTITY);
        if (rowsPerPage != QueryFilter.DEFAULT_PAGE_SIZE) {
            criteria.setFirstResult((this.getPageNumber() - 1) * rowsPerPage);
            criteria.setMaxResults(rowsPerPage);
        }
        result.setResults((Collection)criteria.list());
        return result;
    }

    @Override
    public Object resolveValue(String fieldName, String value) {
        Object result = super.resolveValue(fieldName, value);
        if (result != null && result instanceof String) {
            Class<?> fieldClass = this.lookupPropertyClass(fieldName);
            if (fieldClass.isEnum()) {
                try {
                    result = this.resolveEnumValue(fieldClass, value);
                }
                catch (ClassCastException classCastException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (NullPointerException nullPointerException) {}
            } else if (fieldClass.equals(UUID.class)) {
                result = UUID.fromString(value);
            }
        }
        return result;
    }

    protected Object resolveEnumValue(Class propertyClass, String value) {
        Object result = Enum.valueOf(propertyClass, value);
        return result;
    }

    protected Class<?> lookupPropertyClass(String propertyName) {
        SessionFactory factory = WebConfiguration.getInstance().getSessionLookup().getSession().getSessionFactory();
        String[] propPath = propertyName.split("\\.");
        ClassMetadata prevMeta = factory.getClassMetadata(this.clazz);
        Type propertyType = null;
        Class propertyClass = null;
        for (String pathSegment : propPath) {
            propertyType = prevMeta.getPropertyType(pathSegment);
            propertyClass = propertyType.getReturnedClass();
            if (!propertyType.isAssociationType()) continue;
            if (propertyType.isCollectionType()) {
                propertyType = factory.getCollectionMetadata(((CollectionType)propertyType).getRole()).getElementType();
                propertyClass = propertyType.getReturnedClass();
            }
            prevMeta = factory.getClassMetadata(propertyClass);
        }
        return propertyClass;
    }

    public static class AliasDef {
        public String propertyPath;
        public String alias;

        public AliasDef(String propertyPath, String alias) {
            this.propertyPath = propertyPath;
            this.alias = alias;
        }
    }
}

