package com.urbancode.urelease.integration.xldeploy.sync

import com.urbancode.release.rest.framework.ClientIntegrated

class SyncClient <T extends ClientIntegrated<T>> {
    List<T> importList
    T syncObject
    int syncMax
    int importCount
    int removalCount

    public SyncClient(T syncObject, int syncMax) {
        this.importList = new ArrayList<T>()
        this.syncObject = syncObject
        this.syncMax = syncMax
        this.importCount = 0
    }

    public void addImport(T newImport) {
        importList.add(newImport)

        if (importList.size() >= syncMax) {
            syncImports()
        }
    }

    public void syncImports() {
        if (importList.size() > 0) {
            List<T> imported = syncObject.sync(importList)
            importList.clear()
            importCount += imported.size()
        }
    }

    public void syncRemovals() {
        removalCount = 0
    }
}
