/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonPrimitive;
import com.urbancode.release.rest.models.internal.IntegrationProvider;
import com.urbancode.release.rest.models.internal.InternalClients;
import com.urbancode.release.rest.models.internal.PhaseModel;
import com.urbancode.release.rest.models.internal.PluginIntegrationProvider;

public class UCMobilePluginIntegrationProvider
extends PluginIntegrationProvider<UCMobilePluginIntegrationProvider> {
    private static String URL_PROP = "cloudHostName";
    private static String PHASE_PROP = "phasesSelected";
    private static String ADMIN_EMAIL_PROP = "adminEmail";
    private static String ADMIN_NAME_PROP = "adminName";
    private static String ADMIN_PHONE_PROP = "adminPhone";
    private static String UCR_TOKEN_PROP = "ucr_token";
    private static String UCCLOUD_URL = "https://uccloud.mybluemix.net";
    private static String REGISTER_STEP = "registerUCRButton";
    private static String PLUGIN_NAME = "IBM UrbanCode Mobile";

    public UCMobilePluginIntegrationProvider() {
        this.property(URL_PROP, UCCLOUD_URL);
        this.plugin(InternalClients.plugin().getLatestVersionByName(PLUGIN_NAME));
    }

    public UCMobilePluginIntegrationProvider adminName(String adminName) {
        return (UCMobilePluginIntegrationProvider)this.property(ADMIN_NAME_PROP, adminName);
    }

    public UCMobilePluginIntegrationProvider adminEmail(String adminEmail) {
        return (UCMobilePluginIntegrationProvider)this.property(ADMIN_EMAIL_PROP, adminEmail);
    }

    public UCMobilePluginIntegrationProvider adminPhone(String adminPhone) {
        return (UCMobilePluginIntegrationProvider)this.property(ADMIN_PHONE_PROP, adminPhone);
    }

    public UCMobilePluginIntegrationProvider phases(PhaseModel ... phases) {
        Object ids = null;
        JsonArray ja = new JsonArray();
        for (PhaseModel pm : phases) {
            ja.add(new JsonPrimitive(pm.id));
        }
        return (UCMobilePluginIntegrationProvider)this.property(PHASE_PROP, ja.toString());
    }

    public boolean isUCRRegistered() {
        return this.propertyValues.get(UCR_TOKEN_PROP) != null && !((String)this.propertyValues.get(UCR_TOKEN_PROP)).isEmpty();
    }

    public void registerUCR(String adminName, String adminEmail, String adminPhone) {
        this.adminEmail(adminEmail).adminName(adminName).adminPhone(adminPhone).save();
        this.runPluginStep(REGISTER_STEP, this.plugin.id);
    }

    public static UCMobilePluginIntegrationProvider createAndRegister(String integrationProviderName, boolean skipIfExists) {
        UCMobilePluginIntegrationProvider result;
        if (!skipIfExists) {
            result = UCMobilePluginIntegrationProvider.createIntegration(integrationProviderName);
            result.registerUCR("Andy Admin", "demoUCMobile@us.ibm.com", "555-555-5555");
        } else {
            result = UCMobilePluginIntegrationProvider.createIntegrationIfNoneExists(integrationProviderName);
            if (!result.isUCRRegistered()) {
                result.registerUCR("Andy Admin", "demoUCMobile@us.ibm.com", "555-555-5555");
            }
        }
        return result;
    }

    public static UCMobilePluginIntegrationProvider createIntegration(String integrationProviderName) {
        UCMobilePluginIntegrationProvider provider = (UCMobilePluginIntegrationProvider)((UCMobilePluginIntegrationProvider)InternalClients.ucmobilePluginIntegrationProvider().defaultStep("Integration").name(integrationProviderName)).save();
        return provider;
    }

    public static UCMobilePluginIntegrationProvider createIntegrationIfNoneExists(String integrationProviderName) {
        IntegrationProvider[] ips;
        for (IntegrationProvider ip : ips = (IntegrationProvider[])InternalClients.integrationProvider().getAll()) {
            if (ip.integrationType != IntegrationProvider.IntegrationProviderType.PLUGIN || !((PluginIntegrationProvider)ip).plugin.name.equalsIgnoreCase(PLUGIN_NAME)) continue;
            return (UCMobilePluginIntegrationProvider)((UCMobilePluginIntegrationProvider)InternalClients.ucmobilePluginIntegrationProvider().id(ip.id)).get();
        }
        return UCMobilePluginIntegrationProvider.createIntegration(integrationProviderName);
    }
}

