/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.proxy;

import com.urbancode.commons.util.concurrent.NamedThreadFactory;
import com.urbancode.commons.web.proxy.KeyedLockManager;
import com.urbancode.commons.web.proxy.ProxyResponse;
import com.urbancode.commons.web.proxy.ProxyResponseFactory;
import com.urbancode.commons.web.util.PercentCodec;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.EncoderException;
import org.apache.http.message.BasicHttpRequest;
import org.apache.log4j.Logger;

public class ReverseProxyCache {
    private static final Logger log = Logger.getLogger(ReverseProxyCache.class);
    public static final String DELETION_MILLIS_KEY = "com.urbancode.anthill3.web.proxy.ReverseProxyCache.deletionInterval";
    public static final Long DELETION_MILLIS_DEFAULT = 30000L;
    private static final long DELETION_MILLIS = Long.getLong("com.urbancode.anthill3.web.proxy.ReverseProxyCache.deletionInterval", DELETION_MILLIS_DEFAULT);
    public static final String PRUNING_MILLIS_KEY = "com.urbancode.anthill3.web.proxy.ReverseProxyCache.pruningInterval";
    public static final Long PRUNING_MILLIS_DEFAULT = 1800000L;
    private static final long PRUNING_MILLIS = Long.getLong("com.urbancode.anthill3.web.proxy.ReverseProxyCache.pruningInterval", PRUNING_MILLIS_DEFAULT);
    public static final String TTL_MINUTES_KEY = "com.urbancode.anthill3.web.proxy.ReverseProxyCache.TTL";
    public static final Long TTL_MINUTES_DEFAULT = 360L;
    private static final long TTL_MILLIS = Long.getLong("com.urbancode.anthill3.web.proxy.ReverseProxyCache.TTL", TTL_MINUTES_DEFAULT) * 60L * 1000L;
    private static final File STORAGE_DIR = new File(System.getProperty("java.io.tmpdir", "/tmp"), "proxy-cache");
    private static final ProxyResponseFactory factory = new ProxyResponseFactory();
    private static final ScheduledExecutorService POOL = Executors.newScheduledThreadPool(5, (ThreadFactory)new NamedThreadFactory("proxy-cache-threads", NamedThreadFactory.ThreadMode.DAEMON));
    final File baseDir = STORAGE_DIR;
    final File storageDir = new File(this.baseDir, "data");
    final File tmpDir = new File(this.baseDir, "tmp");
    final File deleteDir = new File(this.baseDir, "delete");
    final KeyedLockManager lockManager = new KeyedLockManager();
    final ScheduledFuture<?> doScheduledDeletionsTask;
    final ScheduledFuture<?> doPruningTask;

    public ReverseProxyCache() {
        this.storageDir.mkdirs();
        this.tmpDir.mkdirs();
        this.deleteDir.mkdirs();
        for (File f : this.tmpDir.listFiles()) {
            try {
                this.scheduleFileDeletion(f);
            }
            catch (IOException e) {
                log.error((Object)("Failed to schedule left over tmp file for deletion " + f.getName()), (Throwable)e);
            }
        }
        this.doPruningTask = POOL.scheduleAtFixedRate(new Runnable(){

            public void run() {
                try {
                    ReverseProxyCache.this.doPruning();
                }
                catch (IOException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }, 0L, PRUNING_MILLIS, TimeUnit.MILLISECONDS);
        this.doScheduledDeletionsTask = POOL.scheduleAtFixedRate(new Runnable(){

            public void run() {
                ReverseProxyCache.this.doScheduledDeletions();
            }
        }, 0L, DELETION_MILLIS, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.doPruningTask.cancel(false);
        this.doScheduledDeletionsTask.cancel(false);
    }

    String getCacheKey(BasicHttpRequest request) {
        String cacheKey;
        String requestURI = request.getRequestLine().getUri();
        PercentCodec pCodec = new PercentCodec();
        try {
            cacheKey = pCodec.encode(requestURI);
        }
        catch (EncoderException e) {
            throw new RuntimeException(e);
        }
        int h = cacheKey.hashCode();
        String dir = String.format("0x%03X", h & 0xFFF);
        return dir + File.separator + cacheKey;
    }

    public ProxyResponse getCachedResponseForRequest(String requestKey) throws IOException {
        ProxyResponse result = null;
        File cacheFile = new File(this.storageDir, requestKey);
        KeyedLockManager.LockGrant grant = this.lockManager.lock(requestKey, KeyedLockManager.Mode.SHARED);
        if (cacheFile.isFile()) {
            result = factory.fromFile(cacheFile);
            result.lockGrant = grant;
            cacheFile.setLastModified(System.currentTimeMillis());
        } else {
            grant.release();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeCachedResponseForRequest(String requestKey, ProxyResponse proxyResponse) throws IOException {
        File cacheFile = new File(this.storageDir, requestKey);
        File tmpFile = this.createTempFile();
        try {
            factory.toFile(proxyResponse, tmpFile);
            KeyedLockManager.LockGrant grant = this.lockManager.lock(requestKey, KeyedLockManager.Mode.EXCLUSIVE);
            try {
                this.scheduleFileDeletion(cacheFile);
                cacheFile.getParentFile().mkdirs();
                tmpFile.renameTo(cacheFile);
                cacheFile.setLastModified(System.currentTimeMillis());
            }
            finally {
                grant.release();
            }
        }
        finally {
            this.scheduleFileDeletion(tmpFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireCachedResponse(String key) throws IOException {
        File cacheFile = new File(this.storageDir, key);
        KeyedLockManager.LockGrant grant = this.lockManager.lock(key, KeyedLockManager.Mode.EXCLUSIVE);
        try {
            this.scheduleFileDeletion(cacheFile);
        }
        finally {
            grant.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPruning() throws IOException {
        File[] subDirs;
        long horizon = System.currentTimeMillis() - TTL_MILLIS;
        if (log.isTraceEnabled()) {
            Date dHorizon = new Date(horizon);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSSZ");
            log.trace((Object)("Scheduling deletion of cache entries not accessed since " + df.format(dHorizon) + " from " + this.storageDir.getAbsolutePath()));
        }
        if ((subDirs = this.storageDir.listFiles()) == null || subDirs.length == 0) {
            return;
        }
        for (File subDir : subDirs) {
            File[] responses = subDir.listFiles();
            if (responses == null || responses.length == 0) continue;
            for (File f : responses) {
                String key;
                KeyedLockManager.LockGrant grant;
                if (f.isDirectory() || f.getName().startsWith(".") || f.lastModified() >= horizon || (grant = this.lockManager.tryLock(key = f.getName(), KeyedLockManager.Mode.EXCLUSIVE)) == null) continue;
                try {
                    if (f.lastModified() >= horizon) continue;
                    this.scheduleFileDeletion(f);
                }
                finally {
                    grant.release();
                }
            }
        }
    }

    void scheduleFileDeletion(File f) throws IOException {
        UUID uuid = UUID.randomUUID();
        File deletedPath = new File(this.deleteDir, uuid.toString()).getAbsoluteFile();
        if (!f.renameTo(deletedPath) && f.exists()) {
            throw new IOException("Unable to schedule path for deletion: " + f);
        }
    }

    private void doScheduledDeletions() {
        File[] files;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Deleting files in " + this.deleteDir.getAbsolutePath()));
        }
        if ((files = this.deleteDir.listFiles()) != null) {
            for (File f : files) {
                this.delete(f);
            }
        }
    }

    private void delete(File file) {
        file.delete();
    }

    protected File createTempFile() {
        UUID uuid = UUID.randomUUID();
        File tmpFile = new File(this.tmpDir, uuid.toString());
        return tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitToCache(String cacheKey, File tmpFile) throws IOException {
        File cacheFile = new File(this.storageDir, cacheKey);
        boolean doCommit = true;
        KeyedLockManager.LockGrant grant = this.lockManager.lock(cacheKey, KeyedLockManager.Mode.EXCLUSIVE);
        try {
            if (cacheFile.exists()) {
                Date newDate = factory.fromFile(tmpFile).getLastModified();
                Date oldDate = factory.fromFile(cacheFile).getLastModified();
                doCommit = newDate.after(oldDate);
            }
            if (doCommit) {
                this.scheduleFileDeletion(cacheFile);
                cacheFile.getParentFile().mkdirs();
                tmpFile.renameTo(cacheFile);
                cacheFile.setLastModified(System.currentTimeMillis());
            }
        }
        finally {
            grant.release();
        }
    }
}

