/*
 * Licensed Materials - Property of HCL
 * UrbanCode Deploy
 * (c) Copyright HCL Technologies Ltd. 2019. All Rights Reserved.
 */
package com.urbancode.urelease.integration.xldeploy.http

import com.urbancode.release.rest.framework.Clients
import com.urbancode.release.rest.models.Application
import com.urbancode.release.rest.framework.ClientEntity
import com.urbancode.release.rest.models.internal.ApplicationEnvironment
import com.urbancode.release.rest.framework.QueryParams.FilterClass
import com.urbancode.commons.util.query.QueryFilter.FilterType

class UCRClient {
    String ucrUrl
    String ucrToken

    public UCRClient(String ucrUrl, String ucrToken) {
        this.ucrUrl = ucrUrl
        this.ucrToken = ucrToken
    }

    /**
     * Login to UCR.
     */
    public void authenticate() {
        Clients.loginWithToken(ucrUrl, ucrToken)
    }

    /**
     * Get all UCR applications for a given integration provider ID.
     * @param providerId
     * @return A list of all UCR applications for this integration provider.
     */
    public List<Application> getApps(String providerId) {
        List<Application> ucrApps = new Application().filter("integrationProvider.id",
            FilterClass.UUID, FilterType.EQUALS, providerId).when().getAll()

        return ucrApps
    }

}
