/*
 * Licensed Materials - Property of HCL
 * UrbanCode Deploy
 * (c) Copyright HCL Technologies Ltd. 2019. All Rights Reserved.
 */
import com.urbancode.air.AirPluginTool
import com.urbancode.urelease.integration.xldeploy.Integration
import com.urbancode.release.rest.models.internal.PluginIntegrationProvider

import org.apache.log4j.Level
import org.apache.log4j.Logger

final File workDir = new File('.').canonicalFile
AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])
Properties props = apTool.getStepProperties()

String logLevel = props['loggerLevel']
Logger.getRootLogger().setLevel(Level.toLevel(logLevel))
Logger logger = Logger.getLogger(getClass())

Integration integration = new Integration(props)
integration.releaseAuthentication()
integration.runIntegration()