/*
 * Licensed Materials - Property of HCL
 * UrbanCode Deploy
 * (c) Copyright HCL Technologies Ltd. 2019. All Rights Reserved.
 */
package com.urbancode.urelease.integration.xldeploy

import org.apache.log4j.Logger

import com.urbancode.release.rest.models.internal.PluginIntegrationProvider
import com.urbancode.urelease.integration.xldeploy.http.UCRClient
import com.urbancode.urelease.integration.xldeploy.http.XLRestClient

/**
 * Base class for the Integration and TaskExecutor.
 */
abstract class IntegrationBase {
    String integrationProviderId
    PluginIntegrationProvider provider
    XLRestClient xlClient
    UCRClient ucrClient
    Logger logger

    protected IntegrationBase(Properties props) {
        integrationProviderId = props['releaseIntegrationProvider']

        /* Configure UCR client */
        String ucrToken = props['releaseToken']
        String ucrUrl = props['releaseServerUrl']
        ucrClient = new UCRClient(ucrUrl, ucrToken)

        /* Configure XL Deploy client */
        String xlUrl = props['xlUrl']
        String xlUser = props['xlUser']
        String xlPass = props['xlPass']
        xlClient = new XLRestClient(xlUrl, xlUser, xlPass)

        logger = Logger.getLogger(getClass())
    }

    /**
     * Get the integration provider.
     */
    protected void init() {
        /* We retrieve the full provider object */
        provider = new PluginIntegrationProvider().id(integrationProviderId).get()
    }

    protected void releaseAuthentication() {
        ucrClient.authenticate()
    }
}
