# Glourious Turnpike Adventure V (Project Rush) patchset

## If you have applied any of the patches before, please re-extract entire source code, just to make sure that the errors are reproducible to be reported.

- Drop {rage,game} into X:\crazyracer2\src\ and you should be good
- Drop "ROOT_DLL" contents into your titleupdate
- Remember to disable Werror.
- Preferrably, also add socialclub.dll from "OPTIONAL_DLL" to `C:\Program Files\Rockstar Games\Social Club Debug`

## To start game with retail-alike experience with working mission flow:
- in gameconfig.xml (`update.rpf/common/data/`) set SizeOfStack for MISSION to 53000
- Copy _compiled_ scripts.rpf to `update2.rpf/levels/gta5/scripts` (!! REQUIRES REENCRYPTION OF EDITED RPF !!)
- Run executable with `-DoReleaseStartup` argument

## If you edit any rpfs:

- Please use archivefix.exe with any platform/ng/aes key you can find online, and reencrypt any edited rpf file.

##
### General notes:
- launch params: `-noSocialClub -nokeyboardhook -nonetlogs`
- `-noSocialClub` - fixes activation issues
- `-nokeyboardhook` - stops the game from eating keystrokes when frozen
- `-nonetlogs` - fixes a crash with message.log

### additional launch params:
- `-output` - adds debug console output
- `-kbgame` - defaults to gameplay keyboard instead of debug keys
- `-rag` - starts Post Malone's famous song's debug utility
- `-ragUseOwnWindow` - Starts the gameface in it's own window instead of being attacted to a debugger

### deprecated launch params:
- -useFinalShaders - NOT NEEDED, debug shaders are already provided and final shaders do not work with the debug build
- -audiopack - NOT NEEDED, the game already defaults to audio_rel.rpf with the code changes
- -langfilesuffix - NOT NEEDED, the game already defaults to american_rel with the code changes
- -commonpack, -nodebugpack, -usepackfiles, -platformpack, -assetsdir - NOT NEEDED, the code changes already make the game default to loading packed files
- -nonetwork - NOT RECOMMENDED as it crashes the game whenever you exit the pause menu
- -disablecacheloader - NOT NEEDED, the code changes already make the game load the proper cache files

### notes:
- obviously requires v2699 update and update2 rpfs, compiled debug shaders, and a compiled script.rpf
- shaders are loaded from the game folder as loose files in common/shaders, repacking common.rpf is not required
- shader quality has to be higher than normal otherwise it loads from win32_40_lq which we don't have compiled yet
- press LCtrl+Tab to switch keyboard mode from debug to gameplay, otherwise a controller is required
##
# Optional fixes
- "OPTIONAL_FIXES" folder includes a temporary code fix for RGSC and Epic API removal, if you happen to need them, copy from them to X:\westcoast\src