#pragma once

using namespace System;

namespace MyApp
{
	public ref class lockBitmap
	{
	private:
		System::Drawing::Bitmap^ mSrc;
		System::Drawing::Imaging::BitmapData^ mSrcData;
		System::Drawing::Imaging::PixelFormat mPxFrmt;
		int mWidth;
		int mHeight;
		IntPtr mPtr;

	public:
		// RXgN^
		lockBitmap(System::Drawing::Bitmap^ ini)
		{
			if (ini == nullptr)
				return;

			if (mSrc != nullptr)
				this->Free();

			mSrc = ini;
			mWidth = mSrc->Width;
			mHeight = mSrc->Height;
			mPxFrmt = mSrc->PixelFormat;

			// BitmapNX̃bN
			System::Drawing::Rectangle rect = System::Drawing::Rectangle(0, 0, mWidth, mHeight);
			mSrcData = mSrc->LockBits(rect, System::Drawing::Imaging::ImageLockMode::ReadOnly, mPxFrmt);

			mPtr = mSrcData->Scan0;
		}

		// bN
		void Free()
		{
			if (mSrc == nullptr)
				return;

			// BitmapNX̃bN
			mSrc->UnlockBits(mSrcData);

			mSrc = nullptr;
			mWidth = 0;
			mHeight = 0;
			mPtr = IntPtr::Zero;
		}

		// |C^擾
		unsigned char* GetPointer()
		{
			return (unsigned char*)mPtr.ToPointer();
		}
	};
}
