import networkx as nx
from forceatlas import forceatlas2_layout
from writeNodesEdges import writeObjects
import sys
generation = int(sys.argv[1])
H = nx.dorogovtsev_goltsev_mendes_graph(generation)

# Force Atlas 2 from https://github.com/tpoisot/nxfa2.git
pos = forceatlas2_layout(H, iterations=100, kr=0.001, dim=3)

# convert to list of positions (each is a list)
xyz = [list(pos[i]) for i in pos]

print nx.number_of_nodes(H), 'nodes and', nx.number_of_edges(H), 'edges'
degree = H.degree(H.nodes()).values()
writeObjects(xyz, edges=H.edges(), scalar=degree,
        name='degree', power=0.333,
        fileout='network')
