import networkx as nx
from forceatlas import forceatlas2_layout
from writeNodesEdges import writeObjects
H = nx.dorogovtsev_goltsev_mendes_graph(5)
pos = forceatlas2_layout(H, iterations=100, kr=0.001, dim=2)
print nx.number_of_nodes(H), 'nodes and', nx.number_of_edges(H), 'edges'
degree = H.degree(H.nodes()).values()
xyz = [[pos[i][0], pos[i][1], (degree[i])**0.5/5.7] for i in pos]

# compute and print eigenvector centrality
ec = nx.eigenvector_centrality(H) # dictionary of nodes with EC as the value
ecList = [ec[i] for i in ec]
print 'degree =', degree
print 'eigenvector centrality =', ecList
print 'min/max =', min(ecList), max(ecList)

writeObjects(xyz, edges=H.edges(),
        scalar=degree, name='degree', power=0.333,
        scalar2=ecList, name2='eigenvector centrality', power2=0.333,
        fileout='network')
