import networkx as nx
from writeNodesEdges import writeObjects
H = nx.florentine_families_graph()
nodes = H.nodes()

# index edges by their node IDs
edges = []
for edge in H.edges():
    edges.append([nodes.index(edge[0]),nodes.index(edge[1])])

# return a dictionary of positions keyed by node
pos = nx.spring_layout(H,dim=3,k=1)

# convert to list of positions (each is a list)
xyz = [list(pos[i]) for i in pos]

degree = [1]*len(nodes)
selection = ['Strozzi', 'Tornabuoni', 'Albizzi']
for i in selection:
    degree[nodes.index(i)] = 3
writeObjects(xyz, edges=edges, scalar=degree, name='degree',
             fileout='network', nodeLabel=nodes, power=0.333)
