import networkx as nx
from writeNodesEdges import writeObjects

numberNodes, numberEdges = 100, 500
H = nx.moebius_kantor_graph()
print nx.number_of_nodes(H), 'nodes and', nx.number_of_edges(H), 'edges'

# return a dictionary of positions keyed by node
pos = nx.spring_layout(H,dim=3,k=1)

# convert to list of positions (each is a list)
xyz = [list(pos[i]) for i in pos]

degree = H.degree().values()
print 'degree =', degree
writeObjects(xyz, edges=H.edges(), scalar=degree,
             name='degree', fileout='network')
