import networkx as nx
from writeNodesEdges import writeObjects

numberNodes, numberEdges = 100, 500
H = nx.gnm_random_graph(numberNodes,numberEdges)
print 'nodes:', H.nodes()
print 'edges:', H.edges()

# return a dictionary of positions keyed by node
pos = nx.spring_layout(H,dim=3,k=1)

# convert to list of positions (each is a list)
xyz = [list(pos[i]) for i in pos]

degree = H.degree().values()
writeObjects(xyz, edges=H.edges(), scalar=degree,
             name='degree', fileout='network')
