#include "FEDataStructures.h"
#include <mpi.h>

#ifdef USE_CATALYST
#include "CatalystAdaptor.h"
#endif

int main(int argc, char* argv[]) {
  MPI_Init(&argc, &argv);
  Grid grid = (Grid){ .NumberOfPoints = 0, .Points = 0, .NumberOfCells = 0, .Cells = 0 };
  unsigned int numPoints[3] = { 50, 50, 50 };
  InitializeGrid(&grid, numPoints);
  printf("%d  %d\n", grid.NumberOfPoints, grid.NumberOfCells);
  Attributes attributes;
  InitializeAttributes(&attributes, &grid);

#ifdef USE_CATALYST
  do_catalyst_initialization(argc, argv);
#endif
  unsigned int numberOfTimeSteps = 5;
  unsigned int timeStep;
  for (timeStep = 0; timeStep < numberOfTimeSteps; timeStep++) {
    printf("step = %d \n", timeStep);
    double time = timeStep * 0.1;
    UpdateFields(&attributes, time);

#ifdef USE_CATALYST
    do_catalyst_execute(timeStep, time, &grid, &attributes);
#endif
  }

#ifdef USE_CATALYST
  do_catalyst_finalization();
#endif

  MPI_Finalize();
  return 0;
}
