import pyevtk as pe, numpy as np
arr = np.array                                       # function alias

x = arr([0.,0.2,0.2,0,0,0.2,0.2,0])                  # define a cube
y = arr([0.,0,0.2,0.2,0,0,0.2,0.2])
z = arr([0.,0,0,0,0.2,0.2,0.2,0.2])

x = np.concatenate((x,arr([-0.1,0,0.2,0.1])))        # add first tetrahedron
y = np.concatenate((y,arr([-0.1,-0.3,-0.2,-0.2])))
z = np.concatenate((z,arr([0.,0.,0.,0.15])))

x = np.concatenate((x,arr([-0.1,0,0.2,0.1])))        # add second tetrahedron
y = np.concatenate((y,arr([0,-0.3,-0.2,-0.2])))
z = np.concatenate((z,arr([0.3,0.3,0.3,0.15])))

conns = np.arange(len(x))   # array of vertices
offs = arr([8,12,16])       # indices of the last vertex of each element in the connectivity array
ctypes = arr([pe.vtk.VtkHexahedron.tid, pe.vtk.VtkTetra.tid, pe.vtk.VtkTetra.tid])
cdata = {'density': arr([1., 2, 1])}   # density at cell centres

filename = pe.hl.unstructuredGridToVTK('cells', x, y, z, connectivity=conns,
                                       offsets=offs, cell_types=ctypes, cellData=cdata)






print('conns =', conns)
print('offs =', offs)
# pdata = {'pressure': np.ones(8)*2}   # pressure on all corners
# (..., pointData=pdata)



# ['VtkCellType', 'VtkDataType', 'VtkFile', 'VtkFileType', 'VtkFloat32', 'VtkFloat64', 'VtkGroup', 'VtkHexahedron', 'VtkImageData', 'VtkInt16', 'VtkInt32', 'VtkInt64', 'VtkInt8', 'VtkLine', 'VtkPixel', 'VtkPolyData', 'VtkPolyLine', 'VtkPolyVertex', 'VtkPolygon', 'VtkPyramid', 'VtkQuad', 'VtkQuadraticEdge', 'VtkQuadraticHexahedron', 'VtkQuadraticQuad', 'VtkQuadraticTetra', 'VtkQuadraticTriangle', 'VtkRectilinearGrid', 'VtkStructuredGrid', 'VtkTetra', 'VtkTriangle', 'VtkTriangleStrip', 'VtkUInt16', 'VtkUInt32', 'VtkUInt64', 'VtkUInt8', 'VtkUnstructuredGrid', 'VtkVertex', 'VtkVoxel', 'VtkWedge', 'XmlWriter', '__builtins__', '__cached__', '__doc__', '__file__', '__loader__', '__name__', '__package__', '__spec__', '_array_to_string', '_get_byte_order', '_mix_extents', 'np_to_vtk', 'os', 'sys', 'writeArrayToFile', 'writeArraysToFile', 'writeBlockSize']
