from paraview.simple import *
import paraview.servermanager as sm

renderView1 = GetActiveViewOrCreate('RenderView')
renderView1.ViewSize = [900, 800]
renderView1.InteractionMode = '3D'
renderView1.EnableRayTracing = 1
renderView1.BackEnd = 'OSPRay pathtracer'
renderView1.SamplesPerPixel = 5   # 10-30 for high quality
renderView1.CameraPosition = [-0.74, -0.14, 0.53]
renderView1.CameraFocalPoint = [1.62, 0.3, -0.82]
renderView1.CameraViewUp = [0.49, 0.036, 0.87]
renderView1.CameraParallelScale = 0.71

texture = sm.rendering.ImageTexture()
texture.FileName = sys.argv[1]   # plane texture

plane1 = Plane()

plane1Display = Show(plane1, renderView1)
plane1Display.Representation = 'Surface'
plane1Display.Texture = texture
plane1Display.OSPRayMaterial = 'None'

sphere1 = Sphere()
sphere1.Center = [0.0, 0.0, 0.15]
sphere1.Radius = 0.15
sphere1.ThetaResolution = 30
sphere1.PhiResolution = 30

sphere1Display = Show(sphere1, renderView1)
sphere1Display.Texture = None

sphere1Display = Show(sphere1, renderView1)
sphere1Display.Representation = 'Surface'
sphere1Display.OSPRayMaterial = 'greenGlass'

SaveScreenshot(sys.argv[2], renderView1,
               ImageResolution=[1800, 1600])
