# Programmable Source
# vtkImageData
# output = self.GetOutput()
# ------
import numpy as np
data = np.genfromtxt("/Users/razoumov/Documents/01-webinar/tabulatedGrid.txt",
                     dtype=None, names=True, delimiter=',', autostrip=True)

nx = round(data['x'].shape[0]**(1./3.))
ny = round(data['y'].shape[0]**(1./3.))
nz = round(data['z'].shape[0]**(1./3.))

output.SetDimensions(nx,ny,nz)
output.SetOrigin(0,0,0)
output.SetSpacing(.1,.1,.1)
output.SetExtent(0,nx-1,0,ny-1,0,nz-1)
output.AllocateScalars(vtk.VTK_FLOAT,1)

vtk_data_array = vtk.util.numpy_support.numpy_to_vtk(num_array=data['scalar'].ravel(),
                                                     deep=True, array_type=vtk.VTK_FLOAT)
vtk_data_array.SetNumberOfComponents(1)
vtk_data_array.SetName("density")
output.GetPointData().SetScalars(vtk_data_array)

------
from paraview import util
nx, ny, nz = 10, 10, 10
util.SetOutputWholeExtent(self, [0,nx-1,0,ny-1,0,nz-1])
