# Programmable Source
# vtkImageData
# output = self.GetOutput()
# ------
from numpy import linspace, sin, sqrt

n = 100
output.SetDimensions(n,n,n)
output.SetOrigin(0,0,0)
output.SetSpacing(.1,.1,.1)
output.SetExtent(0,n-1,0,n-1,0,n-1)
output.AllocateScalars(vtk.VTK_FLOAT,1)

x = linspace(-7.5,7.5,n)
y, z = x.reshape(n,1), x.reshape(n,1,1)
data = ((sin(sqrt(y*y+x*x)))**2-0.5)/(0.001*(y*y+x*x)+1.)**2 + \
    ((sin(sqrt(z*z+y*y)))**2-0.5)/(0.001*(z*z+y*y)+1.)**2 + 1.

rho = vtk.vtkFloatArray()
rho.SetName("density")
rho.SetNumberOfComponents(1)
rho.SetNumberOfTuples(n**3)
point = 0
for i in range(n):
    for j in range(n):
        for k in range(n):
            rho.SetValue(point,data[i][k][j])
            point += 1

output.GetPointData().AddArray(rho)

# ------
from numpy import linspace, sin, sqrt

n = 100
output.SetDimensions(n,n,n)
output.SetOrigin(0,0,0)
output.SetSpacing(.1,.1,.1)
output.SetExtent(0,n-1,0,n-1,0,n-1)
output.AllocateScalars(vtk.VTK_FLOAT,1)

x = linspace(-7.5,7.5,n)
y, z = x.reshape(n,1), x.reshape(n,1,1)
data = ((sin(sqrt(y*y+x*x)))**2-0.5)/(0.001*(y*y+x*x)+1.)**2 + \
    ((sin(sqrt(z*z+y*y)))**2-0.5)/(0.001*(z*z+y*y)+1.)**2 + 1.

vtk_data_array = vtk.util.numpy_support.numpy_to_vtk(
    num_array=data.ravel(), deep=True, array_type=vtk.VTK_FLOAT)
vtk_data_array.SetNumberOfComponents(1)
vtk_data_array.SetName("density")
output.GetPointData().SetScalars(vtk_data_array)

------
from paraview import util
n = 100
util.SetOutputWholeExtent(self,
            [0,n-1,0,n-1,0,n-1])
