# programmatically generated point cloud
# https://youtu.be/aPKVrrzYGdo?t=1202
# Programmable Source
# vtkPolyData
# ------
from numpy import abs, random, sin, cos, pi, arcsin

numPoints = int(1e6)
r = abs(random.randn(numPoints))               # 1D array drawn from a normal (Gaussian) distribution
theta = arcsin(2.*random.rand(numPoints)-1.)   # use 1D array drawn from a uniform [0,1) distribution
phi = 2.*pi*random.rand(numPoints)             # use 1D array drawn from a uniform [0,1) distribution

x = r*cos(theta)*sin(phi)
y = r*cos(theta)*cos(phi)
z = r*sin(theta)
coordinates = vtk.numpy_interface.algorithms.make_vector(x, y, z)   # numpy array (numPoints,3)

output.Points = coordinates              # set point coordinates
output.PointData.append(r, "r")          # append a scalar field on points
output.PointData.append(phi, "phi")      # append another scalar field on points

pointIds = vtk.vtkIdList()
pointIds.SetNumberOfIds(numPoints)
for p in range(numPoints):
    pointIds.SetId(p, p)
output.Allocate(1)     # allocate space for a single cell
output.InsertNextCell(vtk.VTK_POLY_VERTEX, pointIds)



# ------
output.Points = coordinates

# ------
points = vtk.vtkPoints()
points.SetData(vtk.numpy_interface.dataset_adapter.
               numpyTovtkDataArray(coordinates, 'Points')) # set coordinates
output.SetPoints(points)    # add these points to vtkPolyData
