# Programmable Source
# vtkPolyData
# # output = self.GetPolyDataOutput()   # get a vtk.PolyData
# ------
import numpy as np

numPoints, length, rounds, phaseShift = 300, 8.0, 5, np.pi/1.5

points = vtk.vtkPoints()   # this will store the points for the Helix
for i in range(0, numPoints):
   x = i * length / numPoints
   y, z = np.sin(i*rounds*2*np.pi/numPoints), np.cos(i*rounds*2*np.pi/numPoints)
   points.InsertPoint(i,x,y,z)             # 1st helix
   y, z = np.sin(i*rounds*2*np.pi/numPoints + phaseShift), np.cos(i*rounds*2*np.pi/numPoints + phaseShift)
   points.InsertPoint(i+numPoints,x,y,z)   # 2nd helix

output.SetPoints(points)        # add these points to vtkPolyData

helix1 = vtk.vtkPolyLine()   # cell forming the 1st helix
helix2 = vtk.vtkPolyLine()   # cell forming the 2nd helix

helix1.GetPointIds().SetNumberOfIds(numPoints)
helix2.GetPointIds().SetNumberOfIds(numPoints)
for i in range(0,numPoints):
   helix1.GetPointIds().SetId(i, i)             # 1st helix: point i from point i in vtkPoints
   helix2.GetPointIds().SetId(i, i+numPoints)   # 2nd helix: point i from point i+numPoints in vtkPoints

links = range(2,numPoints,5)       # a link at every 5th helix point pair starting from the 3rd pair
output.Allocate(2+len(links), 1)   # allocate space for 2 helices and 60 links: each is a single cell

output.InsertNextCell(helix1.GetCellType(), helix1.GetPointIds())   # add 1st helix 'cell'
output.InsertNextCell(helix2.GetCellType(), helix2.GetPointIds())   # add 2nd helix 'cell'

for i in links:
   link = vtk.vtkLine()                            # add a line 
   link.GetPointIds().SetId(0, i)                     # connecting point i (1st helix)
   link.GetPointIds().SetId(1, i+numPoints)           # and point i+numPoints (2nd helix)
   output.InsertNextCell(link.GetCellType(), link.GetPointIds())   # add the link 'cell'
