from evtk.hl import imageToVTK
from numpy import zeros

n = 30
nx, ny, nz, m = n, n, n, 1.2
data = zeros((n,n,n), dtype=float)
for i in range(nx):
    x = ((i+0.5)/float(nx)*2.-1.)*m # x runs from -m to m
    for j in range(ny):
        y = ((j+0.5)/float(ny)*2.-1.)*m # y runs from -m to m
        for k in range(nz):
            z = ((k+0.5)/float(nz)*2.-1.)*m # z runs from -m to m
            data[i][j][k] = ((x*x+y*y-0.64)**2 + (z*z-1.)**2) * \
                            ((y*y+z*z-0.64)**2 + (x*x-1.)**2) * \
                            ((z*z+x*x-0.64)**2 + (y*y-1.)**2)

imageToVTK("./decoCube", pointData={"scalar" : data})

# draw an isosurface at 0.03

# http://xahlee.info/surface/decocube/decocube.html
# last page of http://virtualmathmuseum.org/Surface/a/bk/ImplicitSurfaces.pdf
# http://virtualmathmuseum.org/Surface/bretzel5/bretzel5.html
# http://virtualmathmuseum.org/Surface/pilz/pilz.html
