#include <stdlib.h>
#include <stdio.h>
#include <netcdf.h>
#include <math.h>

int main() {
  int nx = 100, ny = nx, nz = nx, ncid, x_dimid, y_dimid, z_dimid, varid, dimids[3], i, j, k, status;
  float data[nx][ny][nz], x, y, z, r, r0 = 0.4, psi, pi = 3.141592654, scale = 15.;

  for (i = 0; i < nx; i++) {
    x = scale*(((float)i+0.5)/(float)nx-0.5);
    for (j = 0; j < ny; j++) {
      y = scale*(((float)j+0.5)/(float)ny-0.5);
      for (k = 0; k < nz; k++) {
	z = scale*(((float)k+0.5)/(float)nz-0.5);
	data[i][j][k] = (pow(sin(sqrt(y*y+x*x)),2)-0.5)/pow((0.001*(y*y+x*x)+1.),2)+0.5+
	  (pow(sin(sqrt(z*z+y*y)),2)-0.5)/pow((0.001*(z*z+y*y)+1.),2)+0.5;
      }
    }
  }

  status = nc_create("sineEnvelope.nc", NC_CLOBBER, &ncid);

  status = nc_def_dim(ncid, "z", nz, &z_dimid);
  status = nc_def_dim(ncid, "y", ny, &y_dimid);
  status = nc_def_dim(ncid, "x", nx, &x_dimid);

  dimids[0] = x_dimid;
  dimids[1] = y_dimid;
  dimids[2] = z_dimid;

  status = nc_def_var(ncid, "f(x,y,z)", NC_FLOAT, 3, dimids, &varid);
  status = nc_enddef(ncid);
  status = nc_put_var_float(ncid, varid, &data[0][0][0]);
  status = nc_close(ncid);

  return 0;
}
