from paraview.simple import *

sineEnvelopenc = NetCDFReader(FileName=['/home/razoumov/remote/sineEnvelope.nc'])
sineEnvelopenc.Dimensions = '(x, y, z)'

renderView1 = GetActiveViewOrCreate('RenderView')
renderView1.ViewSize = [800, 800]

sineEnvelopencDisplay = Show(sineEnvelopenc, renderView1)
sineEnvelopencDisplay.Representation = 'Outline'
sineEnvelopencDisplay.ColorArrayName = [None, '']
sineEnvelopencDisplay.OSPRayScaleArray = 'density'
sineEnvelopencDisplay.OSPRayScaleFunction = 'PiecewiseFunction'
sineEnvelopencDisplay.SelectOrientationVectors = 'None'
sineEnvelopencDisplay.ScaleFactor = 9.9
sineEnvelopencDisplay.SelectScaleArray = 'None'
sineEnvelopencDisplay.GlyphType = 'Arrow'
sineEnvelopencDisplay.PolarAxes = 'PolarAxesRepresentation'
sineEnvelopencDisplay.ScalarOpacityUnitDistance = 1.7320508075688779
sineEnvelopencDisplay.Slice = 49

renderView1.ResetCamera() # reset view to fit data
renderView1.Update()

ColorBy(sineEnvelopencDisplay, ('POINTS', 'density'))
sineEnvelopencDisplay.RescaleTransferFunctionToDataRange(True, True)
sineEnvelopencDisplay.SetRepresentationType('Volume')
densityLUT = GetColorTransferFunction('density')

ImportPresets(filename='/home/razoumov/remote/colourOpacity.json')
densityLUT.ApplyPreset('Preset', True)
densityPWF = GetOpacityTransferFunction('density')
densityPWF.ApplyPreset('Preset', True)

renderView1.CameraPosition = [-94.1552899462326, 170.51409185935248, 322.3593724556079]
renderView1.CameraFocalPoint = [49.49999999999998, 49.49999999999998, 49.49999999999998]
renderView1.CameraViewUp = [0.12477414900535926, 0.9296696305198195, -0.3466205271318054]
renderView1.CameraParallelScale = 85.73651497465943
renderView1.OrientationAxesVisibility = 0

camera = GetActiveCamera()
numberOfFrames = 90
for i in range(numberOfFrames):
    camera.Azimuth(1)    # rotate by 1 degree
    SaveScreenshot('/home/razoumov/remote/frame%04d'%(i)+'.png', view=renderView1)
