from paraview.simple import *

spherical003nc = NetCDFReader(FileName=['/scratch/razoumov/webinar/mantle/spherical003.nc'])

renderView1 = GetActiveViewOrCreate('RenderView')

clip1 = Clip(Input=spherical003nc)
clip1.ClipType = 'Box'
clip1.Invert = 0
clip1.ClipType.Position = [0.0, 0.0, 0.0]
clip1.ClipType.Rotation = [10.28, -41.67, 3.29]
clip1.ClipType.Length = [12756., 12756., 12756.]

clip1Display = Show(clip1, renderView1, 'UnstructuredGridRepresentation')
clip1Display.Representation = 'Surface'

ColorBy(clip1Display, ('CELLS', 'temperature'))

temperatureLUT = GetColorTransferFunction('temperature')
temperaturePWF = GetOpacityTransferFunction('temperature')
temperatureLUT.ApplyPreset('Rainbow Desaturated', True)

Hide(spherical003nc, renderView1)

renderView1.CameraPosition = [-3076., 9037., 25518.]
renderView1.CameraFocalPoint = [29.85, -177.42, -313.24]
renderView1.CameraViewUp = [-0.25986, 0.899189, -0.352034]
renderView1.CameraParallelScale = 7143.72

SaveScreenshot('/scratch/razoumov/webinar/mantle.png', renderView1, ImageResolution=[1000, 1000])
