from paraview.simple import *

path = '/Users/razoumov/Documents/09-remoteVisWebinar/'
sineEnvelopenc = NetCDFReader(FileName=[path+'sineEnvelope.nc'])

renderView1 = GetActiveViewOrCreate('RenderView')
renderView1.CameraPosition = [-70.9, 194.6, 321.9]
renderView1.CameraFocalPoint = [49.5, 49.5, 49.5]
renderView1.CameraViewUp = [0.08354, 0.89439, -0.43940]
renderView1.CameraParallelScale = 90.

sineEnvelopencDisplay = Show(sineEnvelopenc, renderView1)
sineEnvelopencDisplay.SetRepresentationType('Volume')   # volumetric representation
densityLUT = GetColorTransferFunction('density')        # transfer function
densityPWF = GetOpacityTransferFunction('density')
densityPWF.Points = [0.01944, 0.0, 0.5, 0.0, 1.521604, 0.0, 0.5, 0.0, 1.99497, 1.0, 0.5, 0.0]
densityLUT.ApplyPreset('Cold and Hot', True)            # colourmap

camera = GetActiveCamera()
numberFrames = 90
for i in range(numberFrames):
    camera.Azimuth(1)    # rotate by 1 degree
    print('writing frame%04d'%(i)+'.png')
    SaveScreenshot('frame%04d'%(i)+'.png', renderView1, ImageResolution=[1100, 768])
