from paraview.simple import *

casefoam = OpenFOAMReader(FileName='/home/razoumov/VisThis2019/case.foam')
casefoam.CaseType = 'Decomposed Case'
casefoam.MeshRegions = ['internalMesh']
casefoam.CellArrays = ['U', 'vorticity']

renderView1 = GetActiveViewOrCreate('RenderView')
renderView1.ViewSize = [1075, 638]
renderView1.CameraPosition = [0.0710917, 0.681781, 1.60335]
renderView1.CameraFocalPoint = [1.00209, -0.0937647, 0.0164949]
renderView1.CameraViewUp = [0.244878, 0.920010, -0.305966]
renderView1.CameraParallelScale = 1.34033

calculator1 = Calculator(Input=casefoam)
calculator1.ResultArrayName = 'speed'
calculator1.Function = 'mag(U)'

contour1 = Contour(Input=calculator1)
contour1.ContourBy = ['POINTS', 'speed']
contour1.Isosurfaces = [0.8]
contour1.PointMergeMethod = 'Uniform Binning'

contour1Display = Show(contour1, renderView1)
contour1Display.Representation = 'Surface'
contour1Display.DataAxesGrid = 'GridAxesRepresentation'
contour1Display.SetScalarBarVisibility(renderView1, False)
contour1Display.RescaleTransferFunctionToDataRange(False, True)

vorticityLUT = GetColorTransferFunction('vorticity')
vorticityLUT.RGBPoints = [0., 0.231373, 0.298039, 0.752941, 1654.23, 0.865003, 0.865003, 0.865003, 3308.47, 0.705882, 0.0156863, 0.14902]
vorticityLUT.ScalarRangeInitialized = 1.0
vorticityLUT.ApplyPreset('Rainbow Desaturated', True)

ColorBy(contour1Display, ('POINTS', 'vorticity', 'Y'))
UpdateScalarBarsComponentTitle(vorticityLUT, contour1Display)

SaveScreenshot('/home/razoumov/scratch/tmp/airflow.png', renderView1, ImageResolution=[1100, 768])
