import yt, numpy as np
yt.enable_parallelism()   # turn on MPI parallelism via mpi4py
ds = yt.load("Enzo_64/DD0043/data0043")
sc = yt.create_scene(ds, ('gas', 'density'))
cam = sc.camera
cam.resolution = (1024, 1024)           # resolution of each frame
sc.annotate_domain(ds, color=[1, 1, 1, 0.005])   # draw the domain boundary [r,g,b,alpha]
sc.annotate_grids(ds, alpha=0.005)      # draw grid boundaries
sc.save('frame0000.png', sigma_clip=4)
for i in cam.iter_rotate(np.pi, 900):   # rotate by 180 degrees over 900 frames
    sc.save('frame%04d.png' % (i+1), sigma_clip=4)
