import networkx as nx, sys, locale
from nodesAndEdges import writeNodesEdges
generation = int(sys.argv[1])

H = nx.dorogovtsev_goltsev_mendes_graph(generation)

locale.setlocale(locale.LC_ALL, '')   # auto configuration
print(f'{nx.number_of_nodes(H):n}', 'nodes and', f'{nx.number_of_edges(H):n}', 'edges')

pos = nx.spring_layout(H, dim=3, k=0.003)   # slower
# pos = nx.spectral_layout(H, dim=3)        # faster, not as nice

xyz = [list(pos[i]) for i in pos] # list of positions (each is a list [x,y,z])

degree = [d for i,d in H.degree(H.nodes())]
writeNodesEdges(xyz, edges=H.edges(), scalar=[degree], name=['degree'], fileout='network9')
