import networkx as nx
from nodesAndEdges import writeNodesEdges
H = nx.dorogovtsev_goltsev_mendes_graph(5)
pos = nx.spring_layout(H, dim=3)
print(nx.number_of_nodes(H), 'nodes and', nx.number_of_edges(H), 'edges')
degree = [d for i,d in H.degree(H.nodes())]
xyz = [[pos[i][0], pos[i][1], (degree[i])**0.5/5.7] for i in pos]

# compute and print eigenvector centrality
ec = nx.eigenvector_centrality(H) # dictionary of nodes with EC as the value
ecList = [ec[i] for i in ec]
print('degree =', degree)
print('eigenvector centrality =', ecList)
print('min/max =', min(ecList), max(ecList))

writeNodesEdges(xyz, edges=H.edges(), scalar=[degree,ecList], name=['degree', 'eigenvector centrality'],
                power=[0.333,0.333], fileout='network')
