import networkx as nx
from nodesAndEdges import writeNodesEdges

numberNodes, numberEdges = 100, 500
H = nx.gnm_random_graph(numberNodes,numberEdges)
print('nodes:', H.nodes())
print('edges:', H.edges())

# return a dictionary of positions keyed by node
pos = nx.random_layout(H,dim=3)

# convert to list of positions (each is a list)
xyz = [list(pos[i]) for i in pos]

degree = [d for i,d in H.degree()]
writeNodesEdges(xyz, edges=H.edges(), scalar=[degree],
                name=['degree'], fileout='network')
