### Block Development Examples - Basic Esnext a2ab62

The goal of this example is to show how to create a basic block with ESNext and JSX syntax and a build process.

<!-- Please, do not remove these @TABLE EXAMPLES BEGIN and @TABLE EXAMPLES END comments or modify the table inside. This table is automatically generated from the data at _data/examples.json and _data/tags.json -->
<!-- @TABLE EXAMPLES BEGIN -->
| Folder                                                                                               | <span style="display: inline-block; width:250px">Short description</span> | Tags                                                                                                                           | ID ([❓](https://github.com/WordPress/block-development-examples/wiki/04-Why-an-ID-for-every-example%3F "Why an ID for every example?")) | Download .zip                                                                                                                                                                                                                                                   | Live Demo                                                                                                                                                                                                                                                                                                                                                                           |
| ---------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------ | --------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [📁](https://github.com/WordPress/block-development-examples/tree/trunk/plugins/basic-esnext-a2ab62) | Basic ESNext                                                              | <small><code><a href="https://github.com/WordPress/block-development-examples/wiki/03-Tags#minimal">MINIMAL</a></code></small> | `a2ab62`                                                                                                                                | [📦](https://raw.githubusercontent.com/WordPress/block-development-examples/deploy/zips/basic-esnext-a2ab62.zip "Install the plugin using this zip and activate it. Then use the ID of the block (a2ab62) to find it and add it to a post to see it in action") | [![](https://raw.githubusercontent.com/WordPress/block-development-examples/trunk/_assets/icon-wp.svg)](https://playground.wordpress.net/?blueprint-url=https://raw.githubusercontent.com/WordPress/block-development-examples/trunk/plugins/basic-esnext-a2ab62/_playground/blueprint.json "Use the ID of the block (a2ab62) to find it and add it to a post to see it in action") |
<!-- @TABLE EXAMPLES END -->

## Understanding the Example Code

This is a static block (check `src/save.js`) that requires a `build` version that can be registered as a block. To do that the `wp-scripts` provide very handy scripts such as `npm start` and `npm run build`.

## Related resources

- [Block Editor Handbook > Getting Started](https://developer.wordpress.org/block-editor/getting-started/)
- [Block Editor Handbook > Fundamentals of Block Development > Static or Dynamic rendering of a block](https://developer.wordpress.org/block-editor/getting-started/fundamentals/)
- [Block Editor Handbook > Fundamentals of Block Development > Registration of a block](https://developer.wordpress.org/block-editor/getting-started/fundamentals/registration-of-a-block/)

> **Note**
> Check the [Start Guide for local development with the examples](https://github.com/WordPress/block-development-examples/wiki/02-Examples#start-guide-for-local-development-with-the-examples)
