# Example: Block Stylesheet

<!-- Please, do not remove these @TABLE EXAMPLES BEGIN and @TABLE EXAMPLES END comments or modify the table inside. This table is automatically generated from the data at _data/examples.json and _data/tags.json -->
<!-- @TABLE EXAMPLES BEGIN -->
| Folder                                                                                       | Short description        | Tags                                                                                                                                                                                                                                                                         | Download .zip                                                                                                    | Live Demo                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| -------------------------------------------------------------------------------------------- | ------------------------ | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [📁](https://github.com/WordPress/block-theme-examples/tree/master/example-block-stylesheet) | example-block-stylesheet | <small><code><a target="_blank" href="https://github.com/WordPress/block-theme-examples/wiki/Tags#block-theme">BLOCK THEME</a></code></small>, <small><code><a target="_blank" href="https://github.com/WordPress/block-theme-examples/wiki/Tags#php">PHP</a></code></small> | [📦](https://raw.githubusercontent.com/WordPress/block-theme-examples/master/_zips/example-block-stylesheet.zip) | [![](https://raw.githubusercontent.com/WordPress/block-theme-examples/master/_assets/icon-wp.svg)](https://playground.wordpress.net/#{%22$schema%22:%22https://playground.wordpress.net/blueprint-schema.json%22,%22landingPage%22:%22/wp-admin/themes.php%22,%22preferredVersions%22:{%22php%22:%228.0%22,%22wp%22:%22latest%22},%22steps%22:[{%22step%22:%22installTheme%22,%22themeZipFile%22:{%22resource%22:%22wordpress.org/themes%22,%22slug%22:%22twentytwentyfour%22}},{%22step%22:%22installTheme%22,%22themeZipFile%22:{%22resource%22:%22url%22,%22url%22:%22https://raw.githubusercontent.com/WordPress/block-theme-examples/master/_zips/example-block-stylesheet.zip%22},%22options%22:{%22activate%22:true}},{%22step%22:%22login%22,%22username%22:%22admin%22,%22password%22:%22password%22}]}) |
<!-- @TABLE EXAMPLES END -->

This is an example child theme of the [Twenty Twenty-Four](https://wordpress.org/themes/twentytwentyfour/) theme, which is required for this example to work.

The goal of this child theme is to showcase how to add custom block stylesheets to a theme. For more information on this feature, read the [Block Stylesheets](https://developer.wordpress.org/themes/features/block-stylesheets/) documentation in the Theme Handbook.

## Understanding the Example Code

This child theme adds a custom stylesheet for the Image block that is loaded in the editor but only gets loaded on the front end when the block is in use. The design is a simple gradient _faux_ border around the `<img>` element within the Image block.

The code in this example requires two files to achieve the effect:

- `functions.php`: Registers the custom block stylesheet.
- `assets/css/blocks/core-image.css`: Adds the custom CSS for the Image block.
