# Example: Locked Pattern

<!-- Please, do not remove these @TABLE EXAMPLES BEGIN and @TABLE EXAMPLES END comments or modify the table inside. This table is automatically generated from the data at _data/examples.json and _data/tags.json -->
<!-- @TABLE EXAMPLES BEGIN -->
| Folder                                                                                     | Short description      | Tags                                                                                                                                                                                                                                                                                   | Download .zip                                                                                                  | Live Demo                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| ------------------------------------------------------------------------------------------ | ---------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [📁](https://github.com/WordPress/block-theme-examples/tree/master/example-locked-pattern) | example-locked-pattern | <small><code><a target="_blank" href="https://github.com/WordPress/block-theme-examples/wiki/Tags#block-theme">BLOCK THEME</a></code></small>, <small><code><a target="_blank" href="https://github.com/WordPress/block-theme-examples/wiki/Tags#curation">CURATION</a></code></small> | [📦](https://raw.githubusercontent.com/WordPress/block-theme-examples/master/_zips/example-locked-pattern.zip) | [![](https://raw.githubusercontent.com/WordPress/block-theme-examples/master/_assets/icon-wp.svg)](https://playground.wordpress.net/#{%22$schema%22:%22https://playground.wordpress.net/blueprint-schema.json%22,%22landingPage%22:%22/wp-admin/themes.php%22,%22preferredVersions%22:{%22php%22:%228.0%22,%22wp%22:%22latest%22},%22steps%22:[{%22step%22:%22installTheme%22,%22themeZipFile%22:{%22resource%22:%22wordpress.org/themes%22,%22slug%22:%22twentytwentyfour%22}},{%22step%22:%22installTheme%22,%22themeZipFile%22:{%22resource%22:%22url%22,%22url%22:%22https://raw.githubusercontent.com/WordPress/block-theme-examples/master/_zips/example-locked-pattern.zip%22},%22options%22:{%22activate%22:true}},{%22step%22:%22login%22,%22username%22:%22admin%22,%22password%22:%22password%22}]}) |
<!-- @TABLE EXAMPLES END -->

This is a child theme of the [Twenty Twenty-Four](https://wordpress.org/themes/twentytwentyfour/) theme, which is required for this example to work.

The goal of this child theme is to showcase an example of a block pattern that utilizes template locking to only allow the user to edit block content but not edit block settings or styles. To read more about this feature, see the [Locking APIs](https://developer.wordpress.org/block-editor/how-to-guides/curating-the-editor-experience/#locking-apis) section of the Curation documentation in the Block Editor Handbook.

## Understanding the Example Code

This child theme adds a custom block pattern named `Custom Event (Locked)`. The only file with code relevant to this example is:

- `parts/custom-event.php`: Registers a custom pattern.

Within that file, the outer wrapping block has its `templateLock` attribute set to `contentOnly`, which locks the pattern.
