# Example: Template Part Area

<!-- Please, do not remove these @TABLE EXAMPLES BEGIN and @TABLE EXAMPLES END comments or modify the table inside. This table is automatically generated from the data at _data/examples.json and _data/tags.json -->
<!-- @TABLE EXAMPLES BEGIN -->
| Folder                                                                                         | Short description          | Tags                                                                                                                                                                                                                                                                         | Download .zip                                                                                                      | Live Demo                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| ---------------------------------------------------------------------------------------------- | -------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [📁](https://github.com/WordPress/block-theme-examples/tree/master/example-template-part-area) | example-template-part-area | <small><code><a target="_blank" href="https://github.com/WordPress/block-theme-examples/wiki/Tags#block-theme">BLOCK THEME</a></code></small>, <small><code><a target="_blank" href="https://github.com/WordPress/block-theme-examples/wiki/Tags#php">PHP</a></code></small> | [📦](https://raw.githubusercontent.com/WordPress/block-theme-examples/master/_zips/example-template-part-area.zip) | [![](https://raw.githubusercontent.com/WordPress/block-theme-examples/master/_assets/icon-wp.svg)](https://playground.wordpress.net/#{%22$schema%22:%22https://playground.wordpress.net/blueprint-schema.json%22,%22landingPage%22:%22/wp-admin/themes.php%22,%22preferredVersions%22:{%22php%22:%228.0%22,%22wp%22:%22latest%22},%22steps%22:[{%22step%22:%22installTheme%22,%22themeZipFile%22:{%22resource%22:%22wordpress.org/themes%22,%22slug%22:%22twentytwentyfour%22}},{%22step%22:%22installTheme%22,%22themeZipFile%22:{%22resource%22:%22url%22,%22url%22:%22https://raw.githubusercontent.com/WordPress/block-theme-examples/master/_zips/example-template-part-area.zip%22},%22options%22:{%22activate%22:true}},{%22step%22:%22login%22,%22username%22:%22admin%22,%22password%22:%22password%22}]}) |
<!-- @TABLE EXAMPLES END -->

This is an example child theme of the [Twenty Twenty-Four](https://wordpress.org/themes/twentytwentyfour/) theme, which is required for this example to work.

The goal of this child theme is to showcase an example of registering and using a custom template part area. For more information on this feature, read the [Template Parts](https://developer.wordpress.org/themes/templates/template-parts/) documentation in the Theme Handbook.

## Understanding the Example Code

This child theme adds a custom template part area named Sidebar via `functions.php`. It then assigns the `parts/sidebar.html` template part to that area via `theme.json`.

The code in this example requires a few files to achieve the effect:

- `functions.php`: Registers the custom template part area.
- `theme.json`: Assigns the area for the sidebar template part.
- `parts/sidebar.html`: Adds the sidebar template part.

**Note:** To get this example to work withing a child theme, it required copying the entirety of the `/parts` folder from Twenty Twenty-Four and overwriting the `templateParts` property in `theme.json`. But the primary code for actually registering template part areas is in `functions.php`.
