import React, { useEffect, useState } from 'react';

import '../styles/index.widget.css';

const IndexWidget = ( { config, uStoreProvider } ) => {
  const [configState, setConfigState] = useState( null );

  useEffect( () => {
    const updateLinkStyles = async ( linkStyleHrefs ) => {
      const head = document.head;

      for (let linkStyleHref of linkStyleHrefs) {
        const currentStyleLink = head.querySelector( `link[href="${ linkStyleHref }"]` );
        const styleHrefValue = currentStyleLink?.getAttribute( 'href' );

        // if a style link doesn't exist and we add it from widget-block-textarea
        if ( !currentStyleLink && linkStyleHref ) {
          const linkInHead = document.createElement( 'link' );
          linkInHead.rel = 'stylesheet';
          linkInHead.type = 'text/css';
          linkInHead.href = linkStyleHref;
          head.appendChild( linkInHead );
        }

        // if a style exists and we update it
        if ( currentStyleLink && styleHrefValue !== linkStyleHref ) {
          currentStyleLink.href = linkStyleHref;
        }
      }
    };

    if ( config ) {
      try {
        const parsedConfig = JSON.parse( config );
        setConfigState( parsedConfig );
        if ( parsedConfig?.linkStyleHrefs ) {
          updateLinkStyles( parsedConfig?.linkStyleHrefs );
        }
      } catch ( e ) {
        console.error( e );
      }
    }

  }, [config] );

  return (
    <>
      { !!configState && <div dangerouslySetInnerHTML={ { __html: configState?.htmlContent } } /> }
    </>

  );
};

export default IndexWidget;
