import React from 'react'

import '../styles/Inventory.css'

export const Inventory = ( props ) => {
  const { inventory, minQuantity } = props

  return (
    <span className="xw-featured-products-inventory">
      {
        ( inventory && inventory.Quantity < minQuantity )
          ? (
            inventory.AllowOutOfStockPurchase
              ? <div className="xw-featured-products-warning">Out of stock. Delivery may be delayed</div>
              : <div className="xw-featured-products-error">Out of stock</div>
          ) : null
      }
    </span>
  )
}
