export const PRODUCTS_PAGE_SIZE = 8
export const MAX_FEATURED_PRODUCTS = 12
const DEFAULT_NUMBERS_OF_PLACEHOLDERS = 4

export const SWIPER_BREAKPOINTS = {
  XS: {
    SIZE: 320,
    SETTINGS: {
      slidesPerView: 2.4,
      spaceBetween: 10,
    },
  },
  M: {
    SIZE: 768,
    SETTINGS: {
      slidesPerView: 3,
      spaceBetween: 20,
    },
  },
  L: {
    SIZE: 1200,
    SETTINGS: {
      slidesPerView: 4,
      spaceBetween: 20,
    },
  },
}

export const placeholderCurrentCurrency = {
  Symbol: '$',
  Code: 'USD',
}

export const placeholderProductsWidget = Array( DEFAULT_NUMBERS_OF_PLACEHOLDERS ).fill( {
  Name: 'Product Name',
  MinimumPrice: {
    Price: 10,
  },
} )
