import React, { useRef, useState } from 'react'

import { FeaturedProducts } from '../components/FeaturedProducts.js'
import { placeholderCurrentCurrency, placeholderProductsWidget } from '../constants.js'
import { getIsNGProduct } from '../../../../common/utils/getIsNGProduct.js'

import 'swiper/css'
import 'swiper/css/pagination'
import 'swiper/css/navigation'
import '../../common/styles/SwiperStyleFeaturedProducts.css'
import '../FeaturedProducts.css'

export const FeaturedProductsContainer = ( props ) => {
  const {
    configState, uStoreProvider, isPlaceholderCase, id
  } = props
  const [itemsPerSlide, setItemsPerSlide] = useState( 0 )
  const swiperRef = useRef( null )
  const { customState, currentCurrency, currentCulture } = uStoreProvider.state.get()
  const currency = isPlaceholderCase ? placeholderCurrentCurrency : currentCurrency
  const selectedProductsWidget = isPlaceholderCase ? placeholderProductsWidget
    : customState[`featuredProductsWidget_${id}`]
  const isSliderFilled = selectedProductsWidget?.length >= itemsPerSlide
  const isSliderOverFilled = selectedProductsWidget?.length > itemsPerSlide
  const separatorConfigState = configState.separator?.trim().toLowerCase()
  const isTopSeparator = separatorConfigState === 'top'
  const isBothSeparator = separatorConfigState === 'both'
  const isBottomSeparator = separatorConfigState === 'bottom'
  const productAlignment = configState.productsAlignment?.trim().toLowerCase()
  const isLeftAlignedSwiperWrapper = ( !isSliderFilled && productAlignment === 'left' )
  const isRightAlignedSwiperWrapper = ( !isSliderFilled && productAlignment === 'right' )
  const isCenterAlignedSwiperWrapper = ( !isSliderFilled && productAlignment === 'center' )
  const [_, setUrlDetailProduct] = useState( '' )

  const navigateToDetailedProductPage = ( slide ) => ( evt ) => {
    evt.preventDefault()
    const { Type, Attributes } = slide
    const pathProduct =  getIsNGProduct({ Type, Attributes }) ? 'products' : 'product'
    const newPathSegment = `${pathProduct}/${slide.FriendlyID}/${slide.Name.replaceAll( ' ', '-' )}`
    const baseURLToLangCodeRegExp = new RegExp( `(.*\\/${currentCulture.LanguageCode}\\/)`, 'i' )

    const baseURLToLangCodeMatched = window.location.href.match( baseURLToLangCodeRegExp )

    if ( baseURLToLangCodeMatched && baseURLToLangCodeMatched.length > 1 ) {
      const baseURLTillLangCode = baseURLToLangCodeMatched[1]
      const fullProductDetailUrl = `${baseURLTillLangCode}${newPathSegment}`
      setUrlDetailProduct( fullProductDetailUrl )
      window.location.href = fullProductDetailUrl
    }
  }

  const onInitSlider = ( swiper ) => {
    setItemsPerSlide( swiperRef.current?.swiper.params.slidesPerView )
    const { slides } = swiper
    // for cases when slider is not filled we remove margin
    if ( slides.length > 0 && !isSliderFilled ) {
      slides[slides.length - 1].style.marginRight = '0px'
    }
  }

  return (
    <FeaturedProducts
      ref={swiperRef}
      configState={configState}
      currency={currency}
      featuredProductsWidget={selectedProductsWidget}
      isBothSeparator={isBothSeparator}
      isBottomSeparator={isBottomSeparator}
      isCenterAlignedSwiperWrapper={isCenterAlignedSwiperWrapper}
      isLeftAlignedSwiperWrapper={isLeftAlignedSwiperWrapper}
      isPlaceholderCase={isPlaceholderCase}
      isRightAlignedSwiperWrapper={isRightAlignedSwiperWrapper}
      isSliderFilled={isSliderFilled}
      isSliderOverFilled={isSliderOverFilled}
      isTopSeparator={isTopSeparator}
      navigateToDetailedProductPage={navigateToDetailedProductPage}
      onInitSlider={onInitSlider}
      placeholderProductsWidget={placeholderProductsWidget}
    />
  )
}
