const productTypes =
  {
    DYNAMIC: 1,
    STATIC: 2,
    COMPOSITE: 5,
    KIT: 14,
    EASY_UPLOAD: 16,
  }

export const getIsNGProduct = (product) => {
  const { Type, Attributes } = product

  switch (Type) {
  case productTypes.KIT:
  case productTypes.EASY_UPLOAD:
    return true
  case productTypes.STATIC:
  case productTypes.DYNAMIC:
    const NGCompatible = Attributes.find(attribute => attribute.Name === 'NGCompatible')
    return NGCompatible && NGCompatible.Value.toLowerCase() === 'true'
  default:
    return false
  }
}