import React, { useEffect, useState } from 'react'

import { layouts } from './common/constants/layouts.js'
import RefreshIcon from './assets/icons/refresh.svg'

import '../styles/index.widget.css'
import './common/styles/FeaturedWidget.css'
import './styles/variables.css'

function IndexWidget( { config } ) {
  const [configState, setConfigState] = useState( null )
  const [isLoading, setIsLoading] = useState( true )

  useEffect( () => {
    if ( config ) {
      try {
        setConfigState( JSON.parse( config ) )
      } catch ( e ) {
        console.error( e )
      } finally {
        setIsLoading( false )
      }
    }
  }, [config] )

  if ( isLoading ) {
    return (
      <div className="xw-featured-loading">
        <RefreshIcon className="xw-featured-refresh-icon xw-featured-rotating-icon" />
      </div>
    )
  }

  const Layout = layouts[configState?.layout?.trim()?.toLowerCase()]

  return (
    <>
      {!!configState && <Layout configState={configState} />}
    </>

  )
}

export default IndexWidget
