import * as path from 'path'
import MiniCssExtractPlugin from 'mini-css-extract-plugin'
import { fileURLToPath } from 'url'
import HtmlWebpackPlugin from 'html-webpack-plugin';
const __filename = fileURLToPath(import.meta.url)
const __dirname = path.dirname(__filename)

const config = {
  mode: 'development',
  devtool: 'source-map',
  entry: `${path.resolve(__dirname, '../Featured/src/index___WIDGET___.js')}`, // index.js
  output: {
    path: `${path.resolve(__dirname, `../build//dist_dev`)}/Featured`,
    filename: 'main.min.js',
    library: 'Featured',
    assetModuleFilename: 'assets/[hash][ext][query]'
  },
  target: "web",
  externals: {
    react: 'React',
    'react-dom': 'ReactDOM',
    'prop-types': 'PropTypes'
  },
  plugins: [
    new MiniCssExtractPlugin(),
    new HtmlWebpackPlugin({
      template: `${path.resolve(__dirname, '../../Featured/public/index.html')}`,
    }),
  ],
  resolve: {
    extensions: ['*', '.js', '.jsx'],
    modules: [path.resolve(__dirname, '../../node_modules'), 'node_modules']
  },
  module: {
    rules: [
      {
        test: /\.js?$/,
        exclude: /node_modules/,
        use: ["babel-loader"]
      },
      {
        test: /\.svg$/,
        use: [
          {
            loader: '@svgr/webpack',
            options: {
              icon: true
            },
          }
        ],
      },
      {
        test: /assets.*\.(png|gif|jpg|jpeg)?$/,
        type: 'asset/resource'
      },
      {
        test: /assets.*\.(eot|otf|woff|woff2|ttf)?$/,
        type: 'asset/resource',
        exclude: /bootstrap|static/
      },
      {
        test: /\.(css|scss)$/,
        use: [

          {
            loader: MiniCssExtractPlugin.loader
          },
          "css-loader",
          "sass-loader",
        ],
      }
    ]
  },
  devServer: {
    static: {
      directory: path.resolve(__dirname, '../dist_dev/Featured')
    },
    port: 9000,
  }
};

export default config;