import React, { useState } from 'react'

import { DivButton } from '../../common/components/Buttons/DivButton/DivButton.js'
import PlaceholderIcon from '../../assets/icons/placeholder.svg'

import '../styles/CarouselCommonlItemSlide.css'
import '../styles/CarouselItemSlideUnder.css'

export const CarouselItemSlideUnder = React.forwardRef( ( props, refLastSlide ) => {
  const {
    slide,
    index,
    boxAnimation,
    lastElement,
    boxTextLocation,
    boxCtaText,
    boxCtaTextColor,
    boxCtaBackgroundColor,
  } = props

  const [isHover, setIsHover] = useState( false )

  const onMouseEnterFigureHoverOn = () => setIsHover( true )
  const onMouseLeaveFigureHoverOff = () => setIsHover( false )

  return (
    <li
      key={index}
      ref={index === lastElement ? refLastSlide : null}
      className={`xw-featured-carousel-item-${boxTextLocation}-boxTextLocation ${boxAnimation}`}
    >
      <a className="xw-featured-carousel-item-link" href={slide.ctaLink}>
        <div
          className="xw-featured-image-container-under"
          onMouseEnter={onMouseEnterFigureHoverOn}
          onMouseLeave={onMouseLeaveFigureHoverOff}
        >
          {
            slide.boxImage
              ? (
                <img
                  alt={slide.boxText}
                  src={slide.boxImage}
                />
              )
              : (
                <PlaceholderIcon
                  className="xw-featured-carousel-image-placeholder-under-boxTextLocation"
                  height="100%"
                  width="100%"
                />
              )
          }
          {
            boxCtaText && (
              <div className="xw-featured-button-wrapper">
                <DivButton
                  className="xw-featured-position-button-cta"
                  style={{
                    color: boxCtaTextColor,
                    backgroundColor: isHover ? 'black' : boxCtaBackgroundColor,
                    borderColor: isHover ? 'black' : boxCtaBackgroundColor,
                  }}
                >
                  {boxCtaText}
                </DivButton>
              </div>
            )
          }
        </div>
        <div
          className="xw-featured-text-container-under"
          style={{ color: slide.boxTextColor }}
        >
          <h2
            className="xw-featured-text-container-boxtext xw-featured-capitalize-first-letter xw-featured-reset-margin"
            style={{ color: isHover ? undefined : slide.boxTextColor }}
          >
            {slide.boxText}
          </h2>
          <p
            className="xw-featured-text-container-boxsubtext xw-featured-capitalize-first-letter xw-featured-reset-margin"
            style={{
              color: slide.boxSubTextColor,
            }}
          >
            {slide.boxSubtext}
          </p>
        </div>
      </a>
    </li>
  )
} )
